//4.RADIATION PATTERN OF HEXAGONAL ARRAY ANTENNA (RECTANGULAR PLOT) 
//OS-Windows 7
//Scilab 6.0.2
// Antenna Arrays
//Course Instructor Name: Dr. V. A. Sankar Ponnapalli
//Institute Name: Sreyas Institute of Engineering & Technology
clc;
clear;
close;
af=0; //af- Array Factor 
thio=0; //STEERING ANGLE
phio=0; // STEERING ANGLE
phi=%pi/2; // Elevation Angle
thi=-%pi:%pi/10000:%pi; // Azimuthal Angle
r=0.5//Radius
k=2*%pi // Wave Number
    for n=1:6 // NUMBER OF ANTENNA ELEMENTS
        phin=(n-1).*(2.*%pi/6) // Antenna Element Position
        a=(exp(%i.*k.*r.*(((sin(thi)*cos(phi-phin)))-(sin(thio)*cos(phio-phin)))));
        af=a+af;
    end
af1=abs(af); // af1-Array Factor
af1=af1/max(max((af1)));
HAA=20.*log10(af1); // HEXAGONAL ARRAY ANTENNA
plot((thi*57.3),(HAA));
xlabel('THETA');
ylabel('ARRAY FACTOR (dB)')
title('RADIATION PATTERN OF HEXAGONAL ARRAY ANTENNA');
h=gca();
h.data_bounds=[-90,-80;90,0];

// DESCRIPTION OF THE FIGURE: 
//*************************ARRAY FACTOR PROPERTIES***************************
//                            Half Power Beam Width (HPBW): 41.8 (In degrees) 
//                            Side Lobe Level (SLL)       : -11.2 dB
//                            Side Lobe Level Angle (SLLA): 94.1 (In degrees) 
